<?php
/*
Plugin Name: XRDS
Plugin URI: http://singpolyma.net/plugins/xrds/
Description: Add XRDS information to your blog.
Version: 0.1
Author: Stephen Paul Weber
Author URI: http://singpolyma.net/
*/

//Licensed under the GPL

require_once dirname(__FILE__).'/../../wp-config.php';

function xrds_meta($echo=true) {
	$tag = '<meta http-equiv="X-XRDS-Location" content="'.get_bloginfo('home').'?xrds">'."\n";
	$tag .= '<meta http-equiv="X-Yadis-Location" content="'.get_bloginfo('home').'?xrds">'."\n";
	if($echo) echo $tag;
	return $tag;
}//end xrds_meta

function xrds_write() {
	header('Content-type: application/xrds+xml');
	$services = get_option('xrds_services');
	if(!is_array($services)) $services = array();
	echo '<?xml version="1.0" encoding="UTF-8" ?>'."\n";
	echo '<xrds:XRDS xmlns:xrds="xri://$xrds" xmlns="xri://$xrd*($v*2.0)" xmlns:openid="http://openid.net/xmlns/1.0">'."\n";
	echo '	<XRD>'."\n";
	foreach($services as $service) {
		if($service['raw']) {
			echo $service['raw']."\n";
		} else {
			$priority = $service['priority'] ? htmlspecialchars($service['priority']) : 10; unset($service['priority']);
			echo '		<Service priority="'.$priority.'">'."\n";
			foreach($service as $tag => $value) {
				if(!is_array($value)) $value = array($value);
				foreach($value as $val)
					echo '			<'.htmlspecialchars($tag).'>'.htmlspecialchars($val).'</'.htmlspecialchars($tag).'>'."\n";
			}
			echo '		</Service>'."\n";
		}
	}
	echo '	</XRD>'."\n";
	echo '</xrds:XRDS>';
	if(function_exists('ob_flush')) ob_flush();
	flush();
	exit;
}//end xrds_write

function xrds_checkXML($data) {//returns FALSE if $data is well-formed XML, errorcode otherwise
	$rtrn = 0;
	$theParser = xml_parser_create();
	if(!xml_parse_into_struct($theParser,$data,$vals)) {
		$errorcode = xml_get_error_code($theParser);
		if($errorcode != XML_ERROR_NONE && $errorcode != 27)
			$rtrn = $errorcode;
	}//end if ! parse
	xml_parser_free($theParser);
	return $rtrn;
}//end function checkXML

function xrds_page() {
	$services = get_option('xrds_services');
	if(!is_array($services)) $services = array();

	echo "<div class=\"wrap\">\n";
	echo "<h2>XRDS Services</h2>\n";

	if(isset($_REQUEST['delete'])) {
		unset($services[$_REQUEST['service_name']]);
		update_option('xrds_services', $services);
		echo '<b>Service deleted!</b>';
	}//end if delete

	if($_REQUEST['openid_server']) {
		$types = array();
		if(isset($_REQUEST['openid_sreg'])) {
			$types[] = 'http://openid.net/sreg/1.0';
			$types[] = 'http://openid.net/extensions/sreg/1.1';
		}//end if sreg
		$services['OpenID 2.0'] = array('Type' =>  array('http://specs.openid.net/auth/2.0/signon')+$types,
												'priority' => 10,
												'URI' => $_REQUEST['openid_server'],
												'LocalID' => $_REQUEST['openid_identifier']
											);
		$services['OpenID 1.1'] = array('Type' =>  array('http://openid.net/signon/1.1')+$types,
												'priority' => 20,
												'URI' => $_REQUEST['openid_server'],
												'openid:Delegate' => $_REQUEST['openid_identifier']
											);
		$services['OpenID 1.0'] = array('Type' =>  array('http://openid.net/signon/1.0')+$types,
												'priority' => 30,
												'URI' => $_REQUEST['openid_server'],
												'openid:Delegate' => $_REQUEST['openid_identifier']
											);
		update_option('xrds_services', $services);
		echo '<b>OpenID delegated!</b>';
	}//end if openid_server

	if($_REQUEST['service_xml']) {
		if(!xrds_checkXML($_REQUEST['service_xml'])) {
			$services[$_REQUEST['service_name']] = array('raw' => $_REQUEST['service_xml']);
			update_option('xrds_services', $services);
			echo '<b>New service added!</b>';
		} else echo '<b>Invalid XML!</b>';
	}//end if service_xml

	echo '<ul>';
	foreach($services as $key => $data) {
		if(is_array($data)) $data = implode("\n",$data);
		echo '<li title="'.htmlentities($data).'">'.htmlentities($key).' - <form style="display:inline;" method="post" action=""><input type="hidden" name="service_name" value="'.htmlentities($key).'" /><input type="submit" name="delete" value="Delete" /></form></li>';
	}//end foreach
	echo '</ul>';

	echo "<h3>Delegate an OpenID</h3>\n";
	echo '<form action="" method="post"><div>';
	echo '<label for="openid_server">Server URI</label> &nbsp;<input type="text" name="openid_server" id="openid_server" value="'.htmlentities($services['OpenID 2.0']['URI']).'" /><br />';
	echo '<label for="openid_identifier">OpenID URI</label> <input type="text" name="openid_identifier" id="openid_identifier" value="'.htmlentities($services['OpenID 2.0']['LocalID']).'" /><br />';
	echo '<label for="openid_sreg">Simple Registration?</label> <input type="checkbox" name="openid_sreg" id="openid_sreg" checked="checked" /><br />';
	echo '<input type="submit" value="Save &raquo;" />';
	echo '</div></form>';

	echo "<h3>Add XRDS Service</h3>\n";
	echo '<form action="" method="post"><div>';
	echo '<label for="service_name">Service Name</label> <input type="text" name="service_name" id="service_name" /><br />';
	echo '<label for="service_xml">Service XML</label> <br /> <textarea cols="60" rows="10" name="service_xml" id="service_xml"></textarea><br />';
	echo '<input type="submit" value="Add &raquo;" />';
	echo '</div></form>';

	echo "\n</div>";
}//end xrds_page

function xrds_tab($s) {
	add_submenu_page('options-general.php', 'XRDS', 'XRDS', 1, __FILE__, 'xrds_page');
	return $s;
}//end function
add_action('admin_menu', 'xrds_tab');

if(isset($_GET['xrds'])) {
	xrds_write();
} else {
	if(in_array('application/xrds+xml',explode(',',$_SERVER['HTTP_ACCEPT']))) {
		xrds_write();
	} else {
		header('X-XRDS-Location: '.get_bloginfo('home').'?xrds');
		header('X-Yadis-Location: '.get_bloginfo('home').'?xrds');
	}//end if header
}//end if ! in wordpress

?>
