<?php
/*
Plugin Name: Pempeth - Personal Messeging
Plugin URI: http://singpolyma.net/plugins/pempeth/
Description: Makes your blog a valid Pempeth <http://singpolyma.net/pempeth/> endpoint.
Version: 0.1
Author: Stephen Paul Weber
Author URI: http://singpolyma.net/
*/

require_once dirname(__FILE__).'/../../wp-includes/rewrite.php';
require_once dirname(__FILE__).'/../../wp-config.php';
if(!$wp_rewrite) $wp_rewrite =& new WP_Rewrite();

if(!get_option('pempeth_page')) {
	$pages = get_pages();
	$desired = 'pempeth-endpoint';
	foreach($pages as $page) //in case thoy already have a page named this
		if($page->post_name == $desired) $desired .= '1';
	$data = array(
		'post_title'		=> 'Pempeth Messages',
		'post_content'		=> 'This page is just a <a href="http://singpolyma.net/pempeth/">pempeth</a> endpoint.',
		'post_status'		=> 'publish',
		'post_name'			=> $desired,
		'post_type'			=> 'page',
		'comment_status'	=> 'closed',
		'ping_status'		=> 'closed'
		);
	$id = wp_insert_post($data);
	update_option('pempeth_page_id', $id);
	update_option('pempeth_page', $desired);
}//end if ! pempeth_page

$services = get_option('xrds_services');
if(!is_array($services)) $services = array();
$services['pempeth'] = array(
									'priority' => 10,
									'Type' => array('http://singpolyma.net/pempeth/', 'http://singpolyma.net/pempeth/private/'),
									'URI' => get_bloginfo('home').'/'.get_option('pempeth_page').'/'
								);
update_option('xrds_services', $services);

function do_pempeth() {
	global $post, $user_ID;
	if($post->ID == get_option('pempeth_page_id')) {
		echo 'Message sending...';
		if(count($_GET) > 0 || count($_POST) > 0) {
			$message = '<dl>'."\n";
			foreach($_GET as $key => $val) {
				$message .= '	<dt>'.htmlspecialchars($key).'</dt>'."\n";
				$message .= '		<dd>'.$val.'</dd>'."\n";
			}//end foreach $_GET
			foreach($_POST as $key => $val) {
				$message .= '	<dt>'.htmlspecialchars($key).'</dt>'."\n";
				$message .= '		<dd>'.$val.'</dd>'."\n";
			}//end foreach $_POST
			$message .= '</dl>'."\n";
			$message .= "<br />\n[".htmlspecialchars($_SERVER['REMOTE_ADDR']).']';
			$boundary = md5($message);
			$headers = "From: ".get_bloginfo('admin_email')."\r\nMIME-Version: 1.0\r\nContent-Type: multipart/alternative; boundary=$boundary\r\n\r\nThis is a MIME encoded message.\r\n\r\n";
			$headers .= "--$boundary\r\nContent-Type: text/plain; charset=utf-8\r\nContent-Transfer-Encoding: base64\r\n\r\n".chunk_split(base64_encode(strip_tags($message)));
			$headers .= "--$boundary\r\nContent-Type: text/html; charset=utf-8\r\nContent-Transfer-Encoding: base64\r\n\r\n".chunk_split(base64_encode($message));
			mail(get_bloginfo('admin_email'), 'New Private Message', '', $headers);
			echo 'Message sent...';
		}//end if getting data
	}//end if pempeth_page_id
}//end do_pempeth
add_action('get_header','do_pempeth');

?>
